<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Trusthub\V1;

/**
 * @property \Twilio\Rest\Trusthub\V1 $v1
 * @property \Twilio\Rest\Trusthub\V1\CustomerProfilesList $customerProfiles
 * @property \Twilio\Rest\Trusthub\V1\EndUserList $endUsers
 * @property \Twilio\Rest\Trusthub\V1\EndUserTypeList $endUserTypes
 * @property \Twilio\Rest\Trusthub\V1\PoliciesList $policies
 * @property \Twilio\Rest\Trusthub\V1\SupportingDocumentList $supportingDocuments
 * @property \Twilio\Rest\Trusthub\V1\SupportingDocumentTypeList $supportingDocumentTypes
 * @property \Twilio\Rest\Trusthub\V1\TrustProductsList $trustProducts
 * @method \Twilio\Rest\Trusthub\V1\CustomerProfilesContext customerProfiles(string $sid)
 * @method \Twilio\Rest\Trusthub\V1\EndUserContext endUsers(string $sid)
 * @method \Twilio\Rest\Trusthub\V1\EndUserTypeContext endUserTypes(string $sid)
 * @method \Twilio\Rest\Trusthub\V1\PoliciesContext policies(string $sid)
 * @method \Twilio\Rest\Trusthub\V1\SupportingDocumentContext supportingDocuments(string $sid)
 * @method \Twilio\Rest\Trusthub\V1\SupportingDocumentTypeContext supportingDocumentTypes(string $sid)
 * @method \Twilio\Rest\Trusthub\V1\TrustProductsContext trustProducts(string $sid)
 */
class Trusthub extends Domain {
    protected $_v1;

    /**
     * Construct the Trusthub Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://trusthub.twilio.com';
    }

    /**
     * @return V1 Version v1 of trusthub
     */
    protected function getV1(): V1 {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getCustomerProfiles(): \Twilio\Rest\Trusthub\V1\CustomerProfilesList {
        return $this->v1->customerProfiles;
    }

    /**
     * @param string $sid The unique string that identifies the resource.
     */
    protected function contextCustomerProfiles(string $sid): \Twilio\Rest\Trusthub\V1\CustomerProfilesContext {
        return $this->v1->customerProfiles($sid);
    }

    protected function getEndUsers(): \Twilio\Rest\Trusthub\V1\EndUserList {
        return $this->v1->endUsers;
    }

    /**
     * @param string $sid The unique string that identifies the resource
     */
    protected function contextEndUsers(string $sid): \Twilio\Rest\Trusthub\V1\EndUserContext {
        return $this->v1->endUsers($sid);
    }

    protected function getEndUserTypes(): \Twilio\Rest\Trusthub\V1\EndUserTypeList {
        return $this->v1->endUserTypes;
    }

    /**
     * @param string $sid The unique string that identifies the End-User Type
     *                    resource
     */
    protected function contextEndUserTypes(string $sid): \Twilio\Rest\Trusthub\V1\EndUserTypeContext {
        return $this->v1->endUserTypes($sid);
    }

    protected function getPolicies(): \Twilio\Rest\Trusthub\V1\PoliciesList {
        return $this->v1->policies;
    }

    /**
     * @param string $sid The unique string that identifies the Policy resource
     */
    protected function contextPolicies(string $sid): \Twilio\Rest\Trusthub\V1\PoliciesContext {
        return $this->v1->policies($sid);
    }

    protected function getSupportingDocuments(): \Twilio\Rest\Trusthub\V1\SupportingDocumentList {
        return $this->v1->supportingDocuments;
    }

    /**
     * @param string $sid The unique string that identifies the resource
     */
    protected function contextSupportingDocuments(string $sid): \Twilio\Rest\Trusthub\V1\SupportingDocumentContext {
        return $this->v1->supportingDocuments($sid);
    }

    protected function getSupportingDocumentTypes(): \Twilio\Rest\Trusthub\V1\SupportingDocumentTypeList {
        return $this->v1->supportingDocumentTypes;
    }

    /**
     * @param string $sid The unique string that identifies the Supporting Document
     *                    Type resource
     */
    protected function contextSupportingDocumentTypes(string $sid): \Twilio\Rest\Trusthub\V1\SupportingDocumentTypeContext {
        return $this->v1->supportingDocumentTypes($sid);
    }

    protected function getTrustProducts(): \Twilio\Rest\Trusthub\V1\TrustProductsList {
        return $this->v1->trustProducts;
    }

    /**
     * @param string $sid The unique string that identifies the resource.
     */
    protected function contextTrustProducts(string $sid): \Twilio\Rest\Trusthub\V1\TrustProductsContext {
        return $this->v1->trustProducts($sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Trusthub]';
    }
}